// $Id: CScrollPanel.cpp,v 1.6 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CScrollPanel.hpp"
using Exponent::GUI::Controls::CScrollPanel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CScrollPanel, CControlPanel);

//	===========================================================================
CScrollPanel::CScrollPanel(IControlRoot *root, const long uniqueId, const CRect &area, const CRect &virtualArea) 
			: CControlPanel(root->getParentWindow(), root, uniqueId, area, NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CScrollPanel);

	// Store the virtual area
	m_virtualArea = virtualArea;

	// We start at the top left..
	m_viewPointPosition.setPoint(0, 0);
}

//	===========================================================================
CScrollPanel::~CScrollPanel()
{
	EXPONENT_CLASS_DESTRUCTION(CScrollPanel);
}

//	===========================================================================
void CScrollPanel::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	// Draw the background image, if one is assigned
	if (m_controlRootBackgroundImage)
	{
		graphics.drawImage(m_controlRootBackgroundImage, m_normalisedArea, m_controlRootBackgroundImage->getNormalisedImageSize());
	}
	else
	{
		// Draw the primary image
		this->drawPrimaryImage(graphics, m_doDefaultDrawing);
	}
	// -------------------------------------------------------------------
	// Drawing a scrolling panel
	// A scrolling panel has an offset left hand position
	// Essentially what we are doing is offseting the update area to reprent an
	// position that onscreen doesnt actually exist, we then move drawing so that we
	// draw in the correct place
	// Things to note:
	// 1. The clipping area is the controls actual onscreen real estate...
	// 2. The update area is a relative position for the control -> the parts of it that need updating!!
	// -------------------------------------------------------------------

	// Store the clipping area
	CRect currentClippingArea;
	graphics.getClippingRegion().getCurrentClipRegion(currentClippingArea);

	// Store the original update area - this is relative to us!
	const CRect updateArea = graphics.getUpdateArea();

	// The update area is relative to our top left and is the area within us that should be drawn
	CRect theUpdateArea = updateArea;

	// This is the true update position in the virtual area
	theUpdateArea.offset(m_viewPointPosition);

	// Store the drawing area offset
	const CPoint drawingOffset = graphics.getDrawingAreaOffset();

	// Now we loop through each control, updating sizes as necessary
	for (long i = 0; i < m_controlArray->getArraySize(); i++)
	{
		// Get the control
		IControl *control = (IControl *)m_controlArray->elementAtIndex(i);

		// Check its valid
		if (control)
		{
			// NOTE : The update area is correctly selected relative to our top left
			// We need to make it valid relative to the parent control..
			// The clip area is completely fucked at the moment...
				

			// Get the control position relative to our top left
			CRect controlArea = control->getArea();

			// Check if its inside the update area
			if (theUpdateArea.rectanglesIntersect(controlArea))
			{
				// Then we know that the control is at least partially inside the update area
				// The update area is an actual position along our virtual area.
				// Controls expect that the update area for them will be <= their area with a 0,0 based top left



				// If the control is entirely within the update area, then its update area is its area
				if (theUpdateArea.rectIsInside(controlArea))
				{
					// We should draw the whole control and all the controls that it contains..
					graphics.setUpdateArea(CRect(0, 0, controlArea.getWidth(), controlArea.getHeight()));
				}
				else
				{
					// Get the intersectional area
					CRect intersection;
					CRect::getIntersectionArea(theUpdateArea, controlArea, intersection);

					// This position is still a fixed onscreen position - we want to make it relative for the control
					intersection.offset(CPoint(-controlArea.getLeft(), -controlArea.getTop()));

					// Now we can store that as the update area for this control
					graphics.setUpdateArea(intersection);
				}

				// Get the new clipping area
				CRect intersection;
				CRect::getIntersectionArea(currentClippingArea, control->getAbsoluteRect(), intersection);

				// Store the clipping position
				graphics.getClippingRegion().setCurrentClipRegion(intersection);

				// Now reoffset the graphics area so that controls draw from 0, 0 relative to themselves
				graphics.appendToDrawingAreaOffset(control->getArea().getOrigin());
				graphics.appendToDrawingAreaOffset(m_inverseViewPointPosition);

				// Draw 
				control->drawControl(graphics);

				// Now remove the offset from the graphics area so that future controls draw in the correct place....
				graphics.setDrawingAreaOffset(drawingOffset);

				// Reset the clipping region
				graphics.getClippingRegion().setCurrentClipRegion(currentClippingArea);
			}
		}
	}

	// Reset the drawing offset
	graphics.setDrawingAreaOffset(drawingOffset);

	// Reset the clipping region
	graphics.getClippingRegion().setCurrentClipRegion(currentClippingArea);

	// Store the update area
	graphics.setUpdateArea(updateArea);

	// Draw the bounds
	if (m_drawPanelBounds)
	{
		graphics.getMutablePen()->setColour(m_boundsColour);
		graphics.drawRectangle(m_normalisedArea);
	}
}

//	===========================================================================
void CScrollPanel::updateControl(IControl *control)
{
	m_rootControl->updateControl(control);
}

//	===========================================================================
void CScrollPanel::updateArea(const CRect &area)
{
	CRect theArea = area;
	theArea.offset(m_area.getOrigin());
	theArea.offset(m_inverseViewPointPosition);
	m_rootControl->updateArea(theArea);
}

//	===========================================================================
void CScrollPanel::handleScrollEvent(const CScrollEvent &event)
{
	// Store the view position
	if (event.getDirection() == CScrollEvent::e_scrollHorizontal)
	{
		m_viewPointPosition.setXPosition(event.getViewPort().getLeft());
		m_inverseViewPointPosition.setXPosition(-m_viewPointPosition.getXPosition());
	}
	else
	{
		m_viewPointPosition.setYPosition(event.getViewPort().getTop());
		m_inverseViewPointPosition.setYPosition(-m_viewPointPosition.getYPosition());
	}

	// Flush the position change
	this->flushSizeChange();

	// Redraw the window
	this->update();
}

/*
//	===========================================================================
void CScrollPanel::getVirtualArea(CRect &area)
{
	// Get the max top and the max right
	long top    = 0;
	long right  = 0;
	long height = 0;
	for (long i = 0; i < m_controlArray->getArraySize(); i++)
	{
		IControl *control = this->getControlAtIndex(i, true);
		if (control)
		{
			if (control->getArea().getTop() > top)
			{
				top	   = control->getArea().getTop();
				height = control->getArea().getHeight();
			}
			if (control->getArea().getRight() > right)
			{
				right = control->getArea().getRight();
			}
		}
	}
	
	// Now we can fill in the rectangle
	area.setRect(0, 0, right + 2, top + height + 2);
}*/

//	===========================================================================
void CScrollPanel::handleLeftButtonDown(CMouseEvent &event)
{
	const CPoint originalPosition = event.getMousePosition();

	CPoint thePoint = originalPosition;
	thePoint.offset(m_viewPointPosition);
	event.setMousePosition(thePoint);

	CControlPanel::handleLeftButtonDown(event);

	event.setMousePosition(originalPosition);
}

//	===========================================================================
void CScrollPanel::handleLeftButtonUp(CMouseEvent &event)
{
	const CPoint originalPosition = event.getMousePosition();

	CPoint thePoint = originalPosition;
	thePoint.offset(m_viewPointPosition);
	event.setMousePosition(thePoint);

	CControlPanel::handleLeftButtonUp(event);

	event.setMousePosition(originalPosition);
}

//	===========================================================================
void CScrollPanel::handleRightButtonDown(CMouseEvent &event)
{
	const CPoint originalPosition = event.getMousePosition();

	CPoint thePoint = originalPosition;
	thePoint.offset(m_viewPointPosition);
	event.setMousePosition(thePoint);

	CControlPanel::handleRightButtonDown(event);

	event.setMousePosition(originalPosition);
}

//	===========================================================================
void CScrollPanel::handleRightButtonUp(CMouseEvent &event)
{
	const CPoint originalPosition = event.getMousePosition();

	CPoint thePoint = originalPosition;
	thePoint.offset(m_viewPointPosition);
	event.setMousePosition(thePoint);

	CControlPanel::handleRightButtonUp(event);

	event.setMousePosition(originalPosition);
}

//	===========================================================================
void CScrollPanel::handleDoubleClick(CMouseEvent &event)
{
	const CPoint originalPosition = event.getMousePosition();

	CPoint thePoint = originalPosition;
	thePoint.offset(m_viewPointPosition);
	event.setMousePosition(thePoint);

	CControlPanel::handleDoubleClick(event);

	event.setMousePosition(originalPosition);
}

//	===========================================================================
void CScrollPanel::handleMouseScroll(CMouseEvent &event)
{
	const CPoint originalPosition = event.getMousePosition();

	CPoint thePoint = originalPosition;
	thePoint.offset(m_viewPointPosition);
	event.setMousePosition(thePoint);

	CControlPanel::handleMouseScroll(event);

	event.setMousePosition(originalPosition);
}

//	===========================================================================
void CScrollPanel::handleMouseMovement(CMouseEvent &event)
{
	const CPoint originalPosition = event.getMousePosition();

	CPoint thePoint = originalPosition;
	thePoint.offset(m_viewPointPosition);
	event.setMousePosition(thePoint);

	CControlPanel::handleMouseMovement(event);

	event.setMousePosition(originalPosition);
}

//	===========================================================================
void CScrollPanel::handleMouseLeavingArea(CMouseEvent &event)
{
	const CPoint originalPosition = event.getMousePosition();

	CPoint thePoint = originalPosition;
	thePoint.offset(m_viewPointPosition);
	event.setMousePosition(thePoint);

	CControlPanel::handleMouseLeavingArea(event);

	event.setMousePosition(originalPosition);
}



//	===========================================================================
CPoint CScrollPanel::getWindowOffset()
{
	// This needs to be calculated...
	CPoint point = m_absoluteArea.getOrigin();
	point.offset(m_inverseViewPointPosition);
	return point;
}

//	===========================================================================
void CScrollPanel::getWindowCoordinatesOfControl(IControl *control, CPoint &point)
{
	if (control)
	{
		// First we offset to the controls position
		point.offset(control->getArea().getOrigin());

		// Offset the position
		point.offset(m_inverseViewPointPosition);

		// Then we want to know where we are!
		m_rootControl->getWindowCoordinatesOfControl(this, point);
	}
}

//	===========================================================================
void CScrollPanel::setVirtualArea(const CRect &virtualArea)
{	
	// Store the virtual area
	m_virtualArea = virtualArea;
}

//	===========================================================================
void CScrollPanel::sortChildControls()
{
	m_controlArray->reorder(false);
}
/*
//	===========================================================================
bool CScrollPanel::handleKeyDown(const CKeyboardEvent &event)
{
	return CControlPanel::handleKeyDown(event);
}

//	===========================================================================
bool CScrollPanel::handleKeyUp(const CKeyboardEvent &event)
{
	return CControlPanel::handleKeyUp(event);
}

//	===========================================================================
void CScrollPanel::handleFileDrop(const CDropEvent &event)
{
	// Create the new drop event
	CDropEvent myEvent = event;
	CPoint thePoint    = event.getDropFilePosition();

	// Offset and store the position
	thePoint.offset(-m_scrollOffset.getXPosition(), -m_scrollOffset.getYPosition());
	myEvent.setDropFilePosition(thePoint);

	// Now handle the event
	CControlPanel::handleFileDrop(event);
}*/